#ifndef __VBD_H__
#define __VBD_H__
#include <iostream>
#include <string>
#include <vector>
#include <map>
#include "helper.h"
#include "makeGrid.h"
using namespace std;

void incrementalDetection(Graph& g,vector<int>& inFlow,vector<int>& outFlow,const int flowThreshold, const double areaThreshold,const int numEdge,vector<vector<int>>& prevBlackholes,
						  vector<vector<int>>& prevVolcanos,vector<int>& blackholeEdge,vector<int>& volcanoEdge);

void continuousDetection(Graph& g,vector<int>& inFlow,vector<int>& outFlow,const int flowThreshold, const double areaThreshold,const int numEdge,vector<int>& prevBlackholes,
						 vector<int>& prevVolcanos,vector<vector<int>>& blackholeEdge,vector<vector<int>>& volcanoEdge);

bool checkAndUpdateArea2(double& minLat,double& minLong,double& maxLat,double& maxLong,double fLat,double fLong,double tLat,double tLong,double areaThreshold);

void UpdateBlackholeEdge2(vector<int>& blackhole,vector<int>& blackholeEdge);

void RemoveBlackholeEdgefromEdgeChoice2(vector<int>& blackhole,vector<int>& edgeChoice);

//void BlackholeinitialGridPruning(Graph& g,vector<int>& inFlow,vector<int>& outFlow,const int flowThreshold, const double areaThreshold,const int numEdge,vector<vector<gridCell>>& Grid);

//void BlackholeinitialGridPruning(Graph& g,vector<int>& inFlow,vector<int>& outFlow,const int flowThreshold, const double areaThreshold,const int numEdge,vector<vector<gridCell>>& Grid,vector<int>& pickedEdge,vector<int>& edgeChoice);

void BlackholeinitialGridPruning(Graph& g,vector<int>& inFlow,vector<int>& outFlow,const int flowThreshold, const double areaThreshold,const int numEdge,vector<vector<gridCell>>& Grid,
						vector<int>& pickedEdge,vector<int>& edgeChoice);

void VolcanoinitialGridPruning(Graph& g,vector<int>& inFlow,vector<int>& outFlow,const int flowThreshold, const double areaThreshold,const int numEdge,vector<vector<gridCell>>& Grid,
						vector<int>& pickedEdge,vector<int>& edgeChoice);

void blackholedynamicallyComputeUpperBound(Graph& g,vector<int>& inFlow,vector<int>& outFlow,const int flowThreshold, const double areaThreshold,const int numEdge
								  ,vector<vector<gridCell>>& Grid,vector<int>& pickedEdge,vector<int>& edgeChoice,vector<int>& Blackhole
								  ,double maxLat,double maxLong,double minLat,double minLong);

void blackholedynamicallyComputeUpperBound(Graph& g,vector<int>& inFlow,vector<int>& outFlow,const int flowThreshold, const double areaThreshold,const int numEdge
								  ,vector<vector<gridCell>>& Grid,vector<int>& pickedEdge,vector<int>& edgeChoice,vector<int>& Blackhole
								  ,double maxLat,double maxLong,double minLat,double minLong);

int VolcanoBlackholeDetection(Graph& g,vector<int>& inFlow,vector<int>& outFlow,const Configuration &config,const int numEdge,vector<vector<gridCell>>& Grid
	,double maxLat,double maxLong,double minLat,double minLong,vector<vector<int>>& prevBlackholes,vector<vector<int>>& prevVolcanos,int k,int i,int j, int &continuousBlackhole, int &continuousVolcano);

#endif